/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.boot;

import de.willuhn.io.FileFinder;
import de.willuhn.logging.Logger;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class BootStrap {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 2) {
            BootStrap.usage();
        }
        Logger.info("Bootstrapping system");
        ClassLoader cl = BootStrap.bootStrap(args[1]);
        Logger.info("loading system class");
        Class<?> c = cl.loadClass(args[0]);
        Method m = c.getMethod("main", String[].class);
        String[] params = new String[]{};
        if (args.length > 2) {
            params = new String[args.length - 2];
            System.arraycopy(args, 2, params, 0, args.length - 2);
            for (int i = 0; i < params.length; ++i) {
                Logger.info("forwarding argument: " + params[i]);
            }
        }
        Logger.info("invoking main method");
        m.invoke(null, new Object[]{params});
    }

    private static ClassLoader bootStrap(String baseDir) {
        Logger.info("autodetecting classpath...");
        File f = new File(baseDir);
        URL[] urls = new URL[]{};
        if (!f.canRead() || !f.isDirectory()) {
            Logger.warn("unable to rad directors " + f.getAbsolutePath());
        } else {
            Logger.info("searching in directory " + f.getAbsolutePath());
            FileFinder finder = new FileFinder(f);
            finder.extension(".jar");
            File[] found = finder.findRecursive();
            urls = new URL[found.length];
            for (int i = 0; i < found.length; ++i) {
                File f2 = found[i];
                try {
                    urls[i] = f2.toURI().toURL();
                    Logger.info("  adding: " + urls[i].toString());
                    continue;
                }
                catch (MalformedURLException e) {
                    Logger.warn("  error while converting into url, skipping file");
                }
            }
        }
        Logger.info("creating new classloader");
        return new URLClassLoader(urls);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("  java " + BootStrap.class.getName() + " [1] [2] [3]...");
        System.out.println("    [1]    Vollstaendiger Name der zu ladenden Klasse");
        System.out.println("    [2]    Basis-Verzeichnis, in dem rekursiv nach Jars und Klassen gesucht werden soll.");
        System.out.println("    [3]... Liste von Parametern, die an die eigentlich Anwendung durchgereicht werden sollen.");
        System.exit(1);
    }
}

